/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging.threads;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import com.google.errorprone.annotations.CompileTimeConstant;
import com.google.firebase.messaging.threads.ExecutorFactory;
import com.google.firebase.messaging.threads.ThreadPriority;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class PoolableExecutors {
    private static final ExecutorFactory DEFAULT_INSTANCE;
    private static volatile ExecutorFactory instance;

    private PoolableExecutors() {
    }

    public static ExecutorFactory factory() {
        return instance;
    }

    static void installExecutorFactory(ExecutorFactory instance) {
        if (PoolableExecutors.instance != DEFAULT_INSTANCE) {
            throw new IllegalStateException("Trying to install an ExecutorFactory twice!");
        }
        PoolableExecutors.instance = instance;
    }

    static {
        instance = DEFAULT_INSTANCE = new DefaultExecutorFactory();
    }

    private static class DefaultExecutorFactory
    implements ExecutorFactory {
        private static final long CORE_THREAD_TIMEOUT_SECS = 60L;

        private DefaultExecutorFactory() {
        }

        @Override
        @NonNull
        @SuppressLint(value={"ThreadPoolCreation"})
        public ExecutorService newThreadPool(ThreadPriority priority) {
            return Executors.unconfigurableExecutorService(Executors.newCachedThreadPool());
        }

        @Override
        @NonNull
        @SuppressLint(value={"ThreadPoolCreation"})
        public ExecutorService newThreadPool(ThreadFactory threadFactory, ThreadPriority priority) {
            return Executors.unconfigurableExecutorService(Executors.newCachedThreadPool(threadFactory));
        }

        @Override
        @NonNull
        public ExecutorService newThreadPool(int maxConcurrency, ThreadPriority priority) {
            return this.newThreadPool(maxConcurrency, Executors.defaultThreadFactory(), priority);
        }

        @Override
        @NonNull
        @SuppressLint(value={"ThreadPoolCreation"})
        public ExecutorService newThreadPool(int maxConcurrency, ThreadFactory threadFactory, ThreadPriority priority) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(maxConcurrency, maxConcurrency, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
            executor.allowCoreThreadTimeOut(true);
            return Executors.unconfigurableExecutorService(executor);
        }

        @Override
        @NonNull
        public ExecutorService newSingleThreadExecutor(ThreadPriority priority) {
            return this.newThreadPool(1, priority);
        }

        @Override
        @NonNull
        public ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory, ThreadPriority priority) {
            return this.newThreadPool(1, threadFactory, priority);
        }

        @Override
        @NonNull
        @SuppressLint(value={"ThreadPoolCreation"})
        public ScheduledExecutorService newScheduledThreadPool(int maxConcurrency, ThreadPriority priority) {
            return Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(maxConcurrency));
        }

        @Override
        @NonNull
        @SuppressLint(value={"ThreadPoolCreation"})
        public ScheduledExecutorService newScheduledThreadPool(int maxConcurrency, ThreadFactory threadFactory, ThreadPriority priority) {
            return Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(maxConcurrency, threadFactory));
        }

        @Override
        @NonNull
        @SuppressLint(value={"ThreadPoolCreation"})
        public void executeOneOff(@CompileTimeConstant String moduleName, @CompileTimeConstant String name, ThreadPriority priority, Runnable runnable) {
            new Thread(runnable, name).start();
        }

        @Override
        @NonNull
        @SuppressLint(value={"ThreadPoolCreation"})
        public Future<?> submitOneOff(@CompileTimeConstant String moduleName, @CompileTimeConstant String name, ThreadPriority priority, Runnable runnable) {
            FutureTask<Object> task = new FutureTask<Object>(runnable, null);
            new Thread(task, name).start();
            return task;
        }
    }
}

