/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import java.util.Locale;

public final class SendException
extends Exception {
    public static final int ERROR_UNKNOWN = 0;
    public static final int ERROR_INVALID_PARAMETERS = 1;
    public static final int ERROR_SIZE = 2;
    public static final int ERROR_TTL_EXCEEDED = 3;
    public static final int ERROR_TOO_MANY_MESSAGES = 4;
    private final int errorCode;

    SendException(String error) {
        super(error);
        this.errorCode = this.parseErrorCode(error);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    private int parseErrorCode(String error) {
        if (error == null) {
            return 0;
        }
        switch (error.toLowerCase(Locale.US)) {
            case "invalid_parameters": 
            case "missing_to": {
                return 1;
            }
            case "messagetoobig": {
                return 2;
            }
            case "service_not_available": {
                return 3;
            }
            case "toomanymessages": {
                return 4;
            }
        }
        return 0;
    }
}

