/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.MainThread;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.messaging.FcmExecutors;
import com.google.firebase.messaging.WakeLockHolder;
import com.google.firebase.messaging.WithinAppServiceBinder;
import java.util.concurrent.ExecutorService;

@SuppressLint(value={"UnwrappedWakefulBroadcastReceiver"})
public abstract class EnhancedIntentService
extends Service {
    static final long MESSAGE_TIMEOUT_S = 20L;
    private static final String TAG = "EnhancedIntentService";
    @VisibleForTesting
    final ExecutorService executor = FcmExecutors.newIntentHandleExecutor();
    private Binder binder;
    private final Object lock = new Object();
    private int lastStartId;
    private int runningTasks = 0;

    public final synchronized IBinder onBind(Intent intent) {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"Service received bind request");
        }
        if (this.binder == null) {
            this.binder = new WithinAppServiceBinder(new WithinAppServiceBinder.IntentHandler(){

                @Override
                @KeepForSdk
                public Task<Void> handle(Intent intent) {
                    return EnhancedIntentService.this.processIntent(intent);
                }
            });
        }
        return this.binder;
    }

    @MainThread
    private Task<Void> processIntent(Intent intent) {
        if (this.handleIntentOnMainThread(intent)) {
            return Tasks.forResult(null);
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.executor.execute(() -> {
            try {
                this.handleIntent(intent);
            }
            finally {
                taskCompletionSource.setResult(null);
            }
        });
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int onStartCommand(Intent originalIntent, int flags, int startId) {
        Object object = this.lock;
        synchronized (object) {
            this.lastStartId = startId;
            ++this.runningTasks;
        }
        Intent intent = this.getStartCommandIntent(originalIntent);
        if (intent == null) {
            this.finishTask(originalIntent);
            return 2;
        }
        Task<Void> task = this.processIntent(intent);
        if (task.isComplete()) {
            this.finishTask(originalIntent);
            return 2;
        }
        task.addOnCompleteListener(Runnable::run, unusedTask -> this.finishTask(originalIntent));
        return 3;
    }

    @CallSuper
    public void onDestroy() {
        this.executor.shutdown();
        super.onDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishTask(Intent originalIntent) {
        if (originalIntent != null) {
            WakeLockHolder.completeWakefulIntent(originalIntent);
        }
        Object object = this.lock;
        synchronized (object) {
            --this.runningTasks;
            if (this.runningTasks == 0) {
                this.stopSelfResultHook(this.lastStartId);
            }
        }
    }

    boolean stopSelfResultHook(int startId) {
        return this.stopSelfResult(startId);
    }

    protected Intent getStartCommandIntent(Intent originalIntent) {
        return originalIntent;
    }

    public boolean handleIntentOnMainThread(Intent intent) {
        return false;
    }

    public abstract void handleIntent(Intent var1);
}

