/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.NotificationManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.messaging.CommonNotificationBuilder;
import com.google.firebase.messaging.ImageDownload;
import com.google.firebase.messaging.NotificationParams;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class DisplayNotification {
    private static final int IMAGE_DOWNLOAD_TIMEOUT_SECONDS = 5;
    private final ExecutorService networkIoExecutor;
    private final Context context;
    private final NotificationParams params;

    public DisplayNotification(Context context, NotificationParams params, ExecutorService networkIoExecutor) {
        this.networkIoExecutor = networkIoExecutor;
        this.context = context;
        this.params = params;
    }

    private boolean isAppForeground() {
        KeyguardManager keyguardManager = (KeyguardManager)this.context.getSystemService("keyguard");
        if (keyguardManager.inKeyguardRestrictedInputMode()) {
            return false;
        }
        if (!PlatformVersion.isAtLeastLollipop()) {
            SystemClock.sleep((long)10L);
        }
        int pid = Process.myPid();
        ActivityManager am = (ActivityManager)this.context.getSystemService("activity");
        List appProcesses = am.getRunningAppProcesses();
        if (appProcesses != null) {
            for (ActivityManager.RunningAppProcessInfo process : appProcesses) {
                if (process.pid != pid) continue;
                return process.importance == 100;
            }
        }
        return false;
    }

    boolean handleNotification() {
        if (this.params.getBoolean("gcm.n.noui")) {
            return true;
        }
        if (this.isAppForeground()) {
            return false;
        }
        ImageDownload imageDownload = this.startImageDownloadInBackground();
        CommonNotificationBuilder.DisplayNotificationInfo notificationInfo = CommonNotificationBuilder.createNotificationInfo(this.context, this.params);
        this.waitForAndApplyImageDownload(notificationInfo.notificationBuilder, imageDownload);
        this.showNotification(notificationInfo);
        return true;
    }

    @Nullable
    private ImageDownload startImageDownloadInBackground() {
        String imageUrl = this.params.getString("gcm.n.image");
        ImageDownload imageDownload = ImageDownload.create(imageUrl);
        if (imageDownload != null) {
            imageDownload.start(this.networkIoExecutor);
        }
        return imageDownload;
    }

    private void waitForAndApplyImageDownload(NotificationCompat.Builder n, @Nullable ImageDownload imageDownload) {
        if (imageDownload == null) {
            return;
        }
        try {
            Bitmap bitmap = (Bitmap)Tasks.await(imageDownload.getTask(), (long)5L, (TimeUnit)TimeUnit.SECONDS);
            n.setLargeIcon(bitmap);
            n.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(bitmap).bigLargeIcon((Bitmap)null));
        }
        catch (ExecutionException e) {
            Log.w((String)"FirebaseMessaging", (String)("Failed to download image: " + e.getCause()));
        }
        catch (InterruptedException e) {
            Log.w((String)"FirebaseMessaging", (String)"Interrupted while downloading image, showing notification without it");
            imageDownload.close();
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            Log.w((String)"FirebaseMessaging", (String)"Failed to download image in time, showing notification without it");
            imageDownload.close();
        }
    }

    private void showNotification(CommonNotificationBuilder.DisplayNotificationInfo info) {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"Showing notification");
        }
        NotificationManager notificationManager = (NotificationManager)this.context.getSystemService("notification");
        notificationManager.notify(info.tag, info.id, info.notificationBuilder.build());
    }
}

