/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.DeadObjectException;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.internal.Preconditions;

@KeepForSdk
public class BaseImplementation {

    @KeepForSdk
    public static abstract class ApiMethodImpl<R extends Result, A extends Api.AnyClient>
    extends BasePendingResult<R>
    implements ResultHolder<R> {
        @KeepForSdk
        private final Api.AnyClientKey<A> clientKey;
        @KeepForSdk
        @Nullable
        private final Api<?> api;

        @KeepForSdk
        @NonNull
        public final Api.AnyClientKey<A> getClientKey() {
            return this.clientKey;
        }

        @KeepForSdk
        @Nullable
        public final Api<?> getApi() {
            return this.api;
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        @KeepForSdk
        protected ApiMethodImpl(@NonNull BasePendingResult.CallbackHandler<R> handler) {
            super(var1_1);
            void var1_1;
            this.clientKey = new Api.AnyClientKey();
            this.api = null;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @KeepForSdk
        protected ApiMethodImpl(@NonNull Api.AnyClientKey<A> clientKey, @NonNull GoogleApiClient apiClient) {
            super((GoogleApiClient)Preconditions.checkNotNull((Object)var2_2, (Object)"GoogleApiClient must not be null"));
            void var1_1;
            void var2_2;
            this.clientKey = (Api.AnyClientKey)Preconditions.checkNotNull((Object)var1_1);
            this.api = null;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        protected ApiMethodImpl(@NonNull Api<?> api, @NonNull GoogleApiClient apiClient) {
            super((GoogleApiClient)Preconditions.checkNotNull((Object)var2_2, (Object)"GoogleApiClient must not be null"));
            void var1_1;
            void var2_2;
            Preconditions.checkNotNull((Object)var1_1, (Object)"Api must not be null");
            this.clientKey = var1_1.zab();
            this.api = var1_1;
        }

        @KeepForSdk
        protected abstract void doExecute(@NonNull A var1) throws RemoteException;

        @KeepForSdk
        protected void onSetFailedResult(@NonNull R r) {
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public final void run(@NonNull A client) throws DeadObjectException {
            try {
                void var1_1;
                this.doExecute(var1_1);
                return;
            }
            catch (DeadObjectException deadObjectException) {
                this.setFailedResult((RemoteException)((Object)deadObjectException));
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.setFailedResult(remoteException);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        private void setFailedResult(@NonNull RemoteException e) {
            void var1_1;
            this.setFailedResult(new Status(8, var1_1.getLocalizedMessage(), null));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @KeepForSdk
        public final void setFailedResult(@NonNull Status status) {
            void var1_1;
            Preconditions.checkArgument((boolean)(status.isSuccess() ^ true), (Object)"Failed result must not be success");
            ApiMethodImpl apiMethodImpl = this;
            Object r = apiMethodImpl.createFailedResult((Status)var1_1);
            ((BasePendingResult)apiMethodImpl).setResult(r);
            apiMethodImpl.onSetFailedResult(r);
        }
    }

    @KeepForSdk
    public static interface ResultHolder<R> {
        @KeepForSdk
        public void setFailedResult(@NonNull Status var1);

        @KeepForSdk
        public void setResult(@NonNull R var1);
    }
}

