/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging.cpp;

import com.google.firebase.messaging.cpp.DataPair;
import com.google.firebase.messaging.cpp.SerializedNotification;
import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.ByteVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class SerializedMessage
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_1_12_0();
    }

    public static SerializedMessage getRootAsSerializedMessage(ByteBuffer _bb) {
        return SerializedMessage.getRootAsSerializedMessage(_bb, new SerializedMessage());
    }

    public static SerializedMessage getRootAsSerializedMessage(ByteBuffer _bb, SerializedMessage obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public SerializedMessage __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public String from() {
        int o = this.__offset(4);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer fromAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 1);
    }

    public ByteBuffer fromInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 1);
    }

    public String to() {
        int o = this.__offset(6);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer toAsByteBuffer() {
        return this.__vector_as_bytebuffer(6, 1);
    }

    public ByteBuffer toInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 6, 1);
    }

    public String collapseKey() {
        int o = this.__offset(8);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer collapseKeyAsByteBuffer() {
        return this.__vector_as_bytebuffer(8, 1);
    }

    public ByteBuffer collapseKeyInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 8, 1);
    }

    public DataPair data(int j) {
        return this.data(new DataPair(), j);
    }

    public DataPair data(DataPair obj, int j) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int dataLength() {
        int o = this.__offset(10);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public DataPair.Vector dataVector() {
        return this.dataVector(new DataPair.Vector());
    }

    public DataPair.Vector dataVector(DataPair.Vector obj) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public int rawData(int j) {
        int o = this.__offset(12);
        return o != 0 ? this.bb.get(this.__vector(o) + j * 1) & 0xFF : 0;
    }

    public int rawDataLength() {
        int o = this.__offset(12);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteVector rawDataVector() {
        return this.rawDataVector(new ByteVector());
    }

    public ByteVector rawDataVector(ByteVector obj) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer rawDataAsByteBuffer() {
        return this.__vector_as_bytebuffer(12, 1);
    }

    public ByteBuffer rawDataInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 12, 1);
    }

    public String messageId() {
        int o = this.__offset(14);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer messageIdAsByteBuffer() {
        return this.__vector_as_bytebuffer(14, 1);
    }

    public ByteBuffer messageIdInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 14, 1);
    }

    public String messageType() {
        int o = this.__offset(16);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer messageTypeAsByteBuffer() {
        return this.__vector_as_bytebuffer(16, 1);
    }

    public ByteBuffer messageTypeInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 16, 1);
    }

    public String priority() {
        int o = this.__offset(18);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer priorityAsByteBuffer() {
        return this.__vector_as_bytebuffer(18, 1);
    }

    public ByteBuffer priorityInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 18, 1);
    }

    public int timeToLive() {
        int o = this.__offset(20);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public String error() {
        int o = this.__offset(22);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer errorAsByteBuffer() {
        return this.__vector_as_bytebuffer(22, 1);
    }

    public ByteBuffer errorInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 22, 1);
    }

    public String errorDescription() {
        int o = this.__offset(24);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer errorDescriptionAsByteBuffer() {
        return this.__vector_as_bytebuffer(24, 1);
    }

    public ByteBuffer errorDescriptionInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 24, 1);
    }

    public SerializedNotification notification() {
        return this.notification(new SerializedNotification());
    }

    public SerializedNotification notification(SerializedNotification obj) {
        int o = this.__offset(26);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public boolean notificationOpened() {
        int o = this.__offset(28);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public String link() {
        int o = this.__offset(30);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer linkAsByteBuffer() {
        return this.__vector_as_bytebuffer(30, 1);
    }

    public ByteBuffer linkInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 30, 1);
    }

    public long sentTime() {
        int o = this.__offset(32);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public String originalPriority() {
        int o = this.__offset(34);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer originalPriorityAsByteBuffer() {
        return this.__vector_as_bytebuffer(34, 1);
    }

    public ByteBuffer originalPriorityInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 34, 1);
    }

    public static int createSerializedMessage(FlatBufferBuilder builder, int fromOffset, int toOffset, int collapse_keyOffset, int dataOffset, int raw_dataOffset, int message_idOffset, int message_typeOffset, int priorityOffset, int time_to_live, int errorOffset, int error_descriptionOffset, int notificationOffset, boolean notification_opened, int linkOffset, long sent_time, int original_priorityOffset) {
        builder.startTable(16);
        SerializedMessage.addSentTime(builder, sent_time);
        SerializedMessage.addOriginalPriority(builder, original_priorityOffset);
        SerializedMessage.addLink(builder, linkOffset);
        SerializedMessage.addNotification(builder, notificationOffset);
        SerializedMessage.addErrorDescription(builder, error_descriptionOffset);
        SerializedMessage.addError(builder, errorOffset);
        SerializedMessage.addTimeToLive(builder, time_to_live);
        SerializedMessage.addPriority(builder, priorityOffset);
        SerializedMessage.addMessageType(builder, message_typeOffset);
        SerializedMessage.addMessageId(builder, message_idOffset);
        SerializedMessage.addRawData(builder, raw_dataOffset);
        SerializedMessage.addData(builder, dataOffset);
        SerializedMessage.addCollapseKey(builder, collapse_keyOffset);
        SerializedMessage.addTo(builder, toOffset);
        SerializedMessage.addFrom(builder, fromOffset);
        SerializedMessage.addNotificationOpened(builder, notification_opened);
        return SerializedMessage.endSerializedMessage(builder);
    }

    public static void startSerializedMessage(FlatBufferBuilder builder) {
        builder.startTable(16);
    }

    public static void addFrom(FlatBufferBuilder builder, int fromOffset) {
        builder.addOffset(0, fromOffset, 0);
    }

    public static void addTo(FlatBufferBuilder builder, int toOffset) {
        builder.addOffset(1, toOffset, 0);
    }

    public static void addCollapseKey(FlatBufferBuilder builder, int collapseKeyOffset) {
        builder.addOffset(2, collapseKeyOffset, 0);
    }

    public static void addData(FlatBufferBuilder builder, int dataOffset) {
        builder.addOffset(3, dataOffset, 0);
    }

    public static int createDataVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startDataVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addRawData(FlatBufferBuilder builder, int rawDataOffset) {
        builder.addOffset(4, rawDataOffset, 0);
    }

    public static int createRawDataVector(FlatBufferBuilder builder, byte[] data) {
        return builder.createByteVector(data);
    }

    public static int createRawDataVector(FlatBufferBuilder builder, ByteBuffer data) {
        return builder.createByteVector(data);
    }

    public static void startRawDataVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(1, numElems, 1);
    }

    public static void addMessageId(FlatBufferBuilder builder, int messageIdOffset) {
        builder.addOffset(5, messageIdOffset, 0);
    }

    public static void addMessageType(FlatBufferBuilder builder, int messageTypeOffset) {
        builder.addOffset(6, messageTypeOffset, 0);
    }

    public static void addPriority(FlatBufferBuilder builder, int priorityOffset) {
        builder.addOffset(7, priorityOffset, 0);
    }

    public static void addTimeToLive(FlatBufferBuilder builder, int timeToLive) {
        builder.addInt(8, timeToLive, 0);
    }

    public static void addError(FlatBufferBuilder builder, int errorOffset) {
        builder.addOffset(9, errorOffset, 0);
    }

    public static void addErrorDescription(FlatBufferBuilder builder, int errorDescriptionOffset) {
        builder.addOffset(10, errorDescriptionOffset, 0);
    }

    public static void addNotification(FlatBufferBuilder builder, int notificationOffset) {
        builder.addOffset(11, notificationOffset, 0);
    }

    public static void addNotificationOpened(FlatBufferBuilder builder, boolean notificationOpened) {
        builder.addBoolean(12, notificationOpened, false);
    }

    public static void addLink(FlatBufferBuilder builder, int linkOffset) {
        builder.addOffset(13, linkOffset, 0);
    }

    public static void addSentTime(FlatBufferBuilder builder, long sentTime) {
        builder.addLong(14, sentTime, 0L);
    }

    public static void addOriginalPriority(FlatBufferBuilder builder, int originalPriorityOffset) {
        builder.addOffset(15, originalPriorityOffset, 0);
    }

    public static int endSerializedMessage(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public SerializedMessage get(int j) {
            return this.get(new SerializedMessage(), j);
        }

        public SerializedMessage get(SerializedMessage obj, int j) {
            return obj.__assign(SerializedMessage.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

