/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging.cpp;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.app.JobIntentService;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.cpp.DebugLogging;
import com.google.firebase.messaging.cpp.SerializedEvent;
import com.google.firebase.messaging.cpp.SerializedTokenReceived;
import com.google.flatbuffers.FlatBufferBuilder;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileLock;

public class RegistrationIntentService
extends JobIntentService {
    private static final String TAG = "FirebaseRegService";

    protected void onHandleWork(Intent intent) {
        RegistrationIntentService context = this;
        FirebaseMessaging.getInstance().getToken().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<String>((Context)context){
            final /* synthetic */ Context val$context;
            {
                this.val$context = context;
            }

            public void onComplete(@NonNull Task<String> task) {
                if (!task.isSuccessful()) {
                    Log.w((String)RegistrationIntentService.TAG, (String)"Fetching FCM registration token failed", (Throwable)task.getException());
                    return;
                }
                String token = (String)task.getResult();
                DebugLogging.log(RegistrationIntentService.TAG, String.format("onHandleWork token=%s", token));
                if (token != null) {
                    RegistrationIntentService.writeTokenToInternalStorage(this.val$context, token);
                }
            }
        });
    }

    public static void writeTokenToInternalStorage(Context context, String token) {
        byte[] buffer = RegistrationIntentService.generateTokenByteBuffer(token);
        ByteBuffer sizeBuffer = ByteBuffer.allocate(4);
        sizeBuffer.order(ByteOrder.LITTLE_ENDIAN);
        sizeBuffer.putInt(buffer.length);
        try (FileOutputStream lockFileStream = context.openFileOutput("FIREBASE_CLOUD_MESSAGING_LOCKFILE", 0);
             FileLock lock = lockFileStream.getChannel().lock();
             FileOutputStream outputStream = context.openFileOutput("FIREBASE_CLOUD_MESSAGING_LOCAL_STORAGE", 32768);){
            outputStream.write(sizeBuffer.array());
            outputStream.write(buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static byte[] generateTokenByteBuffer(String token) {
        FlatBufferBuilder builder = new FlatBufferBuilder(0);
        int tokenOffset = builder.createString((CharSequence)(token != null ? token : ""));
        SerializedTokenReceived.startSerializedTokenReceived(builder);
        SerializedTokenReceived.addToken(builder, tokenOffset);
        int tokenReceivedOffset = SerializedTokenReceived.endSerializedTokenReceived(builder);
        SerializedEvent.startSerializedEvent(builder);
        SerializedEvent.addEventType(builder, (byte)2);
        SerializedEvent.addEvent(builder, tokenReceivedOffset);
        builder.finish(SerializedEvent.endSerializedEvent(builder));
        return builder.sizedByteArray();
    }
}

