/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging.cpp;

import android.content.Context;
import android.net.Uri;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.cpp.DataPair;
import com.google.firebase.messaging.cpp.DebugLogging;
import com.google.firebase.messaging.cpp.SerializedEvent;
import com.google.firebase.messaging.cpp.SerializedMessage;
import com.google.firebase.messaging.cpp.SerializedNotification;
import com.google.flatbuffers.FlatBufferBuilder;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileLock;
import java.util.Map;

public class MessageWriter {
    static final String LOCK_FILE = "FIREBASE_CLOUD_MESSAGING_LOCKFILE";
    static final String STORAGE_FILE = "FIREBASE_CLOUD_MESSAGING_LOCAL_STORAGE";
    private static final String TAG = "FIREBASE_MESSAGE_WRITER";
    private static final MessageWriter DEFAULT_INSTANCE = new MessageWriter();

    public static MessageWriter defaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public void writeMessage(Context context, RemoteMessage message, boolean notificationOpened, Uri linkUri) {
        String from = message.getFrom();
        String to = message.getTo();
        String messageId = message.getMessageId();
        String messageType = message.getMessageType();
        Map data = message.getData();
        byte[] rawData = message.getRawData();
        RemoteMessage.Notification notification = message.getNotification();
        String collapseKey = message.getCollapseKey();
        int priority = message.getPriority();
        int originalPriority = message.getOriginalPriority();
        long sentTime = message.getSentTime();
        int timeToLive = message.getTtl();
        if (linkUri == null && notification != null) {
            linkUri = notification.getLink();
        }
        String link = linkUri != null ? linkUri.toString() : null;
        DebugLogging.log(TAG, String.format("onMessageReceived from=%s message_id=%s, data=%s, notification=%s", from, messageId, data == null ? "(null)" : data.toString(), notification == null ? "(null)" : notification.toString()));
        this.writeMessageToInternalStorage(context, from, to, messageId, messageType, null, data, rawData, notification, notificationOpened, link, collapseKey, priority, originalPriority, sentTime, timeToLive);
    }

    void writeMessageEventToInternalStorage(Context context, String messageId, String messageType, String error) {
        this.writeMessageToInternalStorage(context, null, null, messageId, messageType, null, null, null, null, false, null, null, 0, 0, 0L, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeMessageToInternalStorage(Context context, String from, String to, String messageId, String messageType, String error, Map<String, String> data, byte[] rawData, RemoteMessage.Notification notification, boolean notificationOpened, String link, String collapseKey, int priority, int originalPriority, long sentTime, int timeToLive) {
        byte[] buffer = MessageWriter.generateMessageByteBuffer(from, to, messageId, messageType, error, data, rawData, notification, notificationOpened, link, collapseKey, priority, originalPriority, sentTime, timeToLive);
        ByteBuffer sizeBuffer = ByteBuffer.allocate(4);
        sizeBuffer.order(ByteOrder.LITTLE_ENDIAN);
        sizeBuffer.putInt(buffer.length);
        FileLock lock = null;
        try {
            FileOutputStream lockFileStream = context.openFileOutput(LOCK_FILE, 0);
            lock = lockFileStream.getChannel().lock();
            FileOutputStream outputStream = context.openFileOutput(STORAGE_FILE, 32768);
            outputStream.write(sizeBuffer.array());
            outputStream.write(buffer);
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String emptyIfNull(String str) {
        return str != null ? str : "";
    }

    private static String priorityToString(int priority) {
        switch (priority) {
            case 1: {
                return "high";
            }
            case 2: {
                return "normal";
            }
        }
        return "";
    }

    private static byte[] generateMessageByteBuffer(String from, String to, String messageId, String messageType, String error, Map<String, String> data, byte[] rawData, RemoteMessage.Notification notification, boolean notificationOpened, String link, String collapseKey, int priority, int originalPriority, long sentTime, int timeToLive) {
        FlatBufferBuilder builder = new FlatBufferBuilder(0);
        int fromOffset = builder.createString((CharSequence)MessageWriter.emptyIfNull(from));
        int toOffset = builder.createString((CharSequence)MessageWriter.emptyIfNull(to));
        int messageIdOffset = builder.createString((CharSequence)MessageWriter.emptyIfNull(messageId));
        int messageTypeOffset = builder.createString((CharSequence)MessageWriter.emptyIfNull(messageType));
        int errorOffset = builder.createString((CharSequence)MessageWriter.emptyIfNull(error));
        int linkOffset = builder.createString((CharSequence)MessageWriter.emptyIfNull(link));
        int collapseKeyOffset = builder.createString((CharSequence)MessageWriter.emptyIfNull(collapseKey));
        int priorityStringOffset = builder.createString((CharSequence)MessageWriter.priorityToString(priority));
        int originalPriorityStringOffset = builder.createString((CharSequence)MessageWriter.priorityToString(originalPriority));
        int dataOffset = 0;
        if (data != null) {
            int[] dataPairOffsets = new int[data.size()];
            int index = 0;
            for (Map.Entry<String, String> entry : data.entrySet()) {
                int key = builder.createString((CharSequence)entry.getKey());
                int value = builder.createString((CharSequence)entry.getValue());
                dataPairOffsets[index++] = DataPair.createDataPair(builder, key, value);
            }
            dataOffset = SerializedMessage.createDataVector(builder, dataPairOffsets);
        }
        int rawDataOffset = 0;
        if (rawData != null) {
            rawDataOffset = builder.createByteVector(rawData);
        }
        int notificationOffset = 0;
        if (notification != null) {
            int titleOffset = builder.createString((CharSequence)MessageWriter.emptyIfNull(notification.getTitle()));
            int bodyOffset = builder.createString((CharSequence)MessageWriter.emptyIfNull(notification.getBody()));
            int iconOffset = builder.createString((CharSequence)MessageWriter.emptyIfNull(notification.getIcon()));
            int soundOffset = builder.createString((CharSequence)MessageWriter.emptyIfNull(notification.getSound()));
            int badgeOffset = builder.createString((CharSequence)"");
            int tagOffset = builder.createString((CharSequence)MessageWriter.emptyIfNull(notification.getTag()));
            int colorOffset = builder.createString((CharSequence)MessageWriter.emptyIfNull(notification.getColor()));
            int clickActionOffset = builder.createString((CharSequence)MessageWriter.emptyIfNull(notification.getClickAction()));
            int androidChannelIdOffset = builder.createString((CharSequence)MessageWriter.emptyIfNull(notification.getChannelId()));
            int bodyLocalizationKeyOffset = builder.createString((CharSequence)MessageWriter.emptyIfNull(notification.getBodyLocalizationKey()));
            int bodyLocalizationArgsOffset = 0;
            String[] bodyLocalizationArgs = notification.getBodyLocalizationArgs();
            if (bodyLocalizationArgs != null) {
                int index = 0;
                int[] bodyArgOffsets = new int[bodyLocalizationArgs.length];
                for (String arg : bodyLocalizationArgs) {
                    bodyArgOffsets[index++] = builder.createString((CharSequence)arg);
                }
                bodyLocalizationArgsOffset = SerializedNotification.createBodyLocArgsVector(builder, bodyArgOffsets);
            }
            int titleLocalizationKeyOffset = builder.createString((CharSequence)MessageWriter.emptyIfNull(notification.getTitleLocalizationKey()));
            int titleLocalizationArgsOffset = 0;
            String[] titleLocalizationArgs = notification.getTitleLocalizationArgs();
            if (titleLocalizationArgs != null) {
                int index = 0;
                int[] titleArgOffsets = new int[titleLocalizationArgs.length];
                for (String arg : titleLocalizationArgs) {
                    titleArgOffsets[index++] = builder.createString((CharSequence)arg);
                }
                titleLocalizationArgsOffset = SerializedNotification.createTitleLocArgsVector(builder, titleArgOffsets);
            }
            SerializedNotification.startSerializedNotification(builder);
            SerializedNotification.addTitle(builder, titleOffset);
            SerializedNotification.addBody(builder, bodyOffset);
            SerializedNotification.addIcon(builder, iconOffset);
            SerializedNotification.addSound(builder, soundOffset);
            SerializedNotification.addBadge(builder, badgeOffset);
            SerializedNotification.addTag(builder, tagOffset);
            SerializedNotification.addColor(builder, colorOffset);
            SerializedNotification.addClickAction(builder, clickActionOffset);
            SerializedNotification.addAndroidChannelId(builder, androidChannelIdOffset);
            SerializedNotification.addBodyLocKey(builder, bodyLocalizationKeyOffset);
            SerializedNotification.addBodyLocArgs(builder, bodyLocalizationArgsOffset);
            SerializedNotification.addTitleLocKey(builder, titleLocalizationKeyOffset);
            SerializedNotification.addTitleLocArgs(builder, titleLocalizationArgsOffset);
            notificationOffset = SerializedNotification.endSerializedNotification(builder);
        }
        SerializedMessage.startSerializedMessage(builder);
        SerializedMessage.addFrom(builder, fromOffset);
        SerializedMessage.addTo(builder, toOffset);
        SerializedMessage.addMessageId(builder, messageIdOffset);
        SerializedMessage.addMessageType(builder, messageTypeOffset);
        SerializedMessage.addPriority(builder, priorityStringOffset);
        SerializedMessage.addOriginalPriority(builder, originalPriorityStringOffset);
        SerializedMessage.addSentTime(builder, sentTime);
        SerializedMessage.addTimeToLive(builder, timeToLive);
        SerializedMessage.addError(builder, errorOffset);
        SerializedMessage.addCollapseKey(builder, collapseKeyOffset);
        if (data != null) {
            SerializedMessage.addData(builder, dataOffset);
        }
        if (rawData != null) {
            SerializedMessage.addRawData(builder, rawDataOffset);
        }
        if (notification != null) {
            SerializedMessage.addNotification(builder, notificationOffset);
        }
        SerializedMessage.addNotificationOpened(builder, notificationOpened);
        SerializedMessage.addLink(builder, linkOffset);
        int messageOffset = SerializedMessage.endSerializedMessage(builder);
        SerializedEvent.startSerializedEvent(builder);
        SerializedEvent.addEventType(builder, (byte)1);
        SerializedEvent.addEvent(builder, messageOffset);
        builder.finish(SerializedEvent.endSerializedEvent(builder));
        return builder.sizedByteArray();
    }
}

