/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging.cpp;

import android.content.Context;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.cpp.DebugLogging;
import com.google.firebase.messaging.cpp.MessageWriter;
import com.google.firebase.messaging.cpp.RegistrationIntentService;

public class ListenerService
extends FirebaseMessagingService {
    public static final String MESSAGE_TYPE_DELETED = "deleted_messages";
    public static final String MESSAGE_TYPE_SEND_EVENT = "send_event";
    public static final String MESSAGE_TYPE_SEND_ERROR = "send_error";
    private static final String TAG = "FIREBASE_LISTENER";
    private final MessageWriter messageWriter;

    public ListenerService() {
        this(MessageWriter.defaultInstance());
    }

    public ListenerService(MessageWriter messageWriter) {
        this.messageWriter = messageWriter;
    }

    public void onDeletedMessages() {
        DebugLogging.log(TAG, "onDeletedMessages");
        this.messageWriter.writeMessageEventToInternalStorage((Context)this, null, MESSAGE_TYPE_DELETED, null);
    }

    public void onMessageReceived(RemoteMessage message) {
        this.messageWriter.writeMessage((Context)this, message, false, null);
    }

    public void onMessageSent(String messageId) {
        DebugLogging.log(TAG, String.format("onMessageSent messageId=%s", messageId));
        this.messageWriter.writeMessageEventToInternalStorage((Context)this, messageId, MESSAGE_TYPE_SEND_EVENT, null);
    }

    public void onSendError(String messageId, Exception exception) {
        DebugLogging.log(TAG, String.format("onSendError messageId=%s exception=%s", messageId, exception.toString()));
        this.messageWriter.writeMessageEventToInternalStorage((Context)this, messageId, MESSAGE_TYPE_SEND_ERROR, exception.toString());
    }

    public void onNewToken(String token) {
        DebugLogging.log(TAG, String.format("onNewToken token=%s", token));
        RegistrationIntentService.writeTokenToInternalStorage((Context)this, token);
    }
}

