/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.core.app.JobIntentService;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.cpp.DebugLogging;
import com.google.firebase.messaging.cpp.MessageWriter;

public class MessageForwardingService
extends JobIntentService {
    private static final String TAG = "FIREBASE_MSG_FWDR";
    public static final String ACTION_REMOTE_INTENT = "com.google.android.c2dm.intent.RECEIVE";

    public static void enqueueWork(Context context, Intent intent) {
        MessageForwardingService.enqueueWork((Context)context, MessageForwardingService.class, (int)1000, (Intent)intent);
    }

    protected void onHandleWork(Intent intent) {
        MessageForwardingService.handleIntent((Context)this, intent, MessageWriter.defaultInstance());
    }

    static void handleIntent(Context context, Intent intent, MessageWriter messageWriter) {
        DebugLogging.log(TAG, "onHandleIntent " + (intent == null ? "null intent" : (intent.getAction() == null ? "(null)" : intent.getAction())));
        if (intent != null && intent.getAction() != null && intent.getAction().equals(ACTION_REMOTE_INTENT)) {
            Bundle extras = intent.getExtras();
            DebugLogging.log(TAG, "extras: " + (extras == null ? "(null)" : extras.toString()));
            if (extras != null) {
                RemoteMessage message = new RemoteMessage(extras);
                DebugLogging.log(TAG, "message: " + message.toString());
                if (message.getFrom() != null && message.getMessageId() != null) {
                    messageWriter.writeMessage(context, message, true, intent.getData());
                }
            }
        }
    }
}

